/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.WorldUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityCompostedDirt
extends BlockEntity
implements ITickable {
    private boolean composted = false;
    private int ticker = 0;
    private double percentage = 1.0;
    private static final int TICKER_LIMIT = 300;
    private final Random random = new Random();
    private ItemStack flower;

    public TileEntityCompostedDirt(BlockPos pos, BlockState state) {
        super(MinecoloniesTileEntities.COMPOSTED_DIRT, pos, state);
    }

    @Override
    public void tick() {
        Level world = this.m_58904_();
        if (!world.f_46443_ && this.composted && this.ticker % 20 == 0) {
            this.updateTick(world);
        }
        ++this.ticker;
    }

    private void updateTick(@NotNull Level worldIn) {
        BlockPos position;
        if (this.flower == null || this.flower.m_41619_()) {
            this.composted = false;
            return;
        }
        if (this.composted) {
            ((ServerLevel)worldIn).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)this.m_58899_().m_123341_() + 0.5, (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
        }
        if (this.random.nextDouble() * 100.0 <= this.percentage && worldIn.m_8055_(position = this.f_58858_.m_7494_()).m_60734_() instanceof AirBlock) {
            if (this.flower.m_41720_() instanceof BlockItem) {
                if (((BlockItem)this.flower.m_41720_()).m_40614_() instanceof DoublePlantBlock) {
                    DoublePlantBlock cfr_ignored_0 = (DoublePlantBlock)((BlockItem)this.flower.m_41720_()).m_40614_();
                    DoublePlantBlock.m_153173_((LevelAccessor)worldIn, (BlockState)((BlockItem)this.flower.m_41720_()).m_40614_().m_49966_(), (BlockPos)position, (int)3);
                } else {
                    worldIn.m_46597_(position, ((BlockItem)this.flower.m_41720_()).m_40614_().m_49966_());
                }
            } else {
                worldIn.m_46597_(position, BlockUtils.getBlockStateFromStack((ItemStack)this.flower));
            }
        }
        if (this.ticker >= 6000) {
            this.ticker = 0;
            this.composted = false;
        }
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    public void compost(double percentage, @NotNull ItemStack flower) {
        if (percentage >= 0.0 && percentage <= 100.0) {
            this.percentage = percentage;
            try {
                this.flower = flower;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.composted = true;
    }

    public boolean isComposted() {
        return this.composted;
    }
}

